/*****************************************************************************/
/*                         Freescale Semiconductor                           */
/*****************************************************************************/
/* File Type: C Source File                                                  */
/* File Name: Rend_Characters.c                                              */
/* Description: Code to write rendered characters on a NewHeaven TFT display */
/* Author: Jos Santiago Lpez Ramrez                                       */
/* Date: 11/10/10                                                            */
/* Version: 1.2                                                              */
/*****************************************************************************/

/*****************************************************************************/
/*                                 Headers                                   */
/*****************************************************************************/

  #include "Rend_Characters.h"
  #include "TFT.h"
  #include "Colors.h"
  
/*****************************************************************************/
/*                                 Globals                                   */
/*****************************************************************************/
  
extern UINT8 bkgcolor [] = {Black};        //Background color
extern UINT8 fntcolor [] = {White};        //Foreground color
extern UINT8 LookUpTable [LUT_Size][2] = {0};      //Look Up Table


/*****************************************************************************/
/*                                Functions                                  */
/*****************************************************************************/
 
 void Char_Render4bpp (const UINT8 *u8charstring, UINT8 xstartpos, UINT8 ystartpos, UINT8 ltrwidth)
 {
  UINT8 Print_Buffer[BufferSize], Pixel[4], CharRendIndex=0, Turn_Buffer[BufferSize];
  UINT8 Width, Height, Pointer;
  
  Pointer=(UINT8)(ltrwidth%2);
  
  if(Pointer!=0)
  ltrwidth++;
  
  CharRendIndex=1;
  
  for(Height=ltrheight; Height>0; Height--)
  {
   for(Width=1; Width<=ltrwidth; Width+=2)
   {
    /*Separate Pixels*/ 
  
    Pixel[0]=(UINT8)(*u8charstring & 0x0F); 
    Pixel[1]=(UINT8)(*u8charstring & 0xF0); 
    Pixel[1]= (UINT8)(Pixel[1]>>4); 
  
    /*Asign Colors*/ 
  
    Pixel[3]=LookUpTable[(Pixel[1])][1];
    Pixel[2]=LookUpTable[(Pixel[1])][0];  
    Pixel[1]=LookUpTable[(Pixel[0])][1];
    Pixel[0]=LookUpTable[(Pixel[0])][0];   
      
    /*Save on Buffer*/ 
  
    Print_Buffer[CharRendIndex]=Pixel[0];
    CharRendIndex++;             
    Print_Buffer[CharRendIndex]=Pixel[1];
    CharRendIndex++;
    Print_Buffer[CharRendIndex]=Pixel[2];
    CharRendIndex++;
    Print_Buffer[CharRendIndex]=Pixel[3];
    CharRendIndex++;
    u8charstring++;
    }
   }
   CharRendIndex=0;
   for(Width=1;Width<=ltrwidth*2; Width+=2) 
   {
    for(Height=ltrheight; Height>0; Height--) 
    {
     Pointer=(UINT8)(((Height-1)*2*ltrwidth)+Width);
     Turn_Buffer[CharRendIndex]=Print_Buffer[Pointer];
     CharRendIndex++;
     Turn_Buffer[CharRendIndex]=Print_Buffer[Pointer+1];
     CharRendIndex++;
    }
   }
   Turn_Buffer[(ltrheight*ltrwidth*2)+1]=0;
   picArea(xstartpos, xstartpos+ltrheight-1,ystartpos,ystartpos+ltrwidth-1,&Turn_Buffer[0]); 
  }
  
 /****************************************************************************/
 
 void LookUpTableGen_4bpp (void)
 {
  UINT8 HB565,LB565,FC[3],BC[3],indx,subindx;
  UINT32 bkpct=1000,fgpct=0;
  float newcolor;
  
  for(indx=0;indx<LUT_Size;indx++)
  {                             
   for(subindx=0;subindx<3;subindx++)
   {
    newcolor = (fntcolor[subindx]*fgpct)/1000;
    FC[subindx]=(UINT8)newcolor;
    newcolor = (bkgcolor[subindx]*bkpct)/1000;
    BC[subindx]=(UINT8)newcolor;
    
    FC[subindx]+=BC[subindx];
    if (subindx != 1)
    {
     newcolor = (FC[subindx]*31)/255;
    }else
    {
     newcolor = (FC[subindx]*63)/255;
    }
    BC[subindx]=(UINT8)newcolor;
   }
   BC[0] = BC[0]<<3;
   HB565 = BC[1]>>3;
   HB565 |= BC[0];
   LB565 = BC[1]<<5;
   LB565 |= BC[2];
   LookUpTable[indx][0]=HB565;
   LookUpTable[indx][1]=LB565;
   bkpct-=66;
   fgpct+=66;
  } 
 }
 
 /****************************************************************************/
 
 void Char_Render8bpp (const UINT8 *u8charstring, UINT8 xstartpos, UINT8 ystartpos, UINT8 ltrwidth)
 {
  UINT8 Print_Buffer[BufferSize+1], Pixel[2], CharRendIndex=1, Turn_Buffer[BufferSize];
  UINT8 Width, Height, Pointer;
 
  
  for(Height=ltrheight; Height>0; Height--)
  {
   for(Width=1; Width<=ltrwidth; Width++)
   { 
  
    Pixel[0]=*u8charstring;
    
    /*Asign Colors*/ 
 
    Pixel[1]=LookUpTable[(Pixel[0])][1];
    Pixel[0]=LookUpTable[(Pixel[0])][0];   
      
    /*Save on Buffer*/ 
  
    Print_Buffer[CharRendIndex]=Pixel[0];
    CharRendIndex++;             
    Print_Buffer[CharRendIndex]=Pixel[1];
    CharRendIndex++;
    u8charstring++;
    }
   }
   CharRendIndex=0;
   for(Width=1;Width<=ltrwidth*2; Width+=2) 
   {
    for(Height=ltrheight; Height>0; Height--) 
    {
     Pointer=((Height-1)*2*ltrwidth)+Width;
     Turn_Buffer[CharRendIndex]=Print_Buffer[Pointer];
     CharRendIndex++;
     Turn_Buffer[CharRendIndex]=Print_Buffer[Pointer+1];
     CharRendIndex++;
    }
   }
   Turn_Buffer[(ltrheight*ltrwidth*2)+1]=0;
   picArea(xstartpos, xstartpos+ltrheight-1,ystartpos,ystartpos+ltrwidth-1,&Turn_Buffer[0]); 
  }
  
 /****************************************************************************/
 
 void LookUpTableGen_8bpp (void)
 {
  UINT8 HB565,LB565,FC[3],BC[3],subindx;
  UINT32 bkpct=10000,fgpct=0,indx;
  float newcolor;
  
  for(indx=0;indx<LUT_Size;indx++)
  {                             
   for(subindx=0;subindx<3;subindx++)
   {
    newcolor = (fntcolor[subindx]*fgpct)/10000;
    FC[subindx]=(UINT8)newcolor;
    newcolor = (bkgcolor[subindx]*bkpct)/10000;
    BC[subindx]=(UINT8)newcolor;
    
    FC[subindx]+=BC[subindx];
    if (subindx != 1)
    {
     newcolor = (FC[subindx]*31)/255;
    }else
    {
     newcolor = (FC[subindx]*63)/255;
    }
    BC[subindx]=(UINT8)newcolor;
   }
   BC[0] = BC[0]<<3;
   HB565 = BC[1]>>3;
   HB565 |= BC[0];
   LB565 = BC[1]<<5;
   LB565 |= BC[2];
   LookUpTable[indx][0]=HB565;
   LookUpTable[indx][1]=LB565;
   bkpct-=39;
   fgpct+=39;
  } 
 }
/******************************************************************************/ 
 #if 0
    
 void LookUpTableDiag (void)
 {
  UINT8 col, row, colorselect=0;
  
  for(row=0;row<128;row+=8) //row+=32 for 4bpp  row+=8 for 8bpp
    {
     for (col=0;col<160;col+=10)//col+=40 for 4bpp col+=10 for 8bpp
     {
 /***********************************************************************************************/
 /*colorArea(row,row+31,col,col+39,LookUpTable[colorselect][0],LookUpTable[colorselect][1]);4bpp*/
 /*colorArea(row,row+7,col,col+9,LookUpTable[colorselect][0],LookUpTable[colorselect][1]); 8bpp */
 /***********************************************************************************************/           
      colorArea(row,row+7,col,col+9,LookUpTable[colorselect][0],LookUpTable[colorselect][1]);
      colorselect++;
     }
    }
  }
 
 
 #endif                 
 
  /****************************************************************************/

 UINT8 Get_Size (UINT8 Character)
 {
  UINT8 index=1,size=0;
  while (size==0)
  {
   size=Font_Size[index];
   if(size == Character)
   {
    size=Font_Size[index-1];
    return size;
   } 
   else
   {
    size = 0;
   }
   index+=2;
   if (index > 253)
   return 0;
  }
 }
   
   
 /****************************************************************************/

 void Write_Str_LCD (UINT8 *string, UINT8 Xspos, UINT8 Yspos)
 {
  UINT8 width, letter;
  while (*string)
  {
    letter = (char)*string;
    width=Get_Size(letter);
    switch (letter)
    {
      case 'A':
      Char_Render_Type (&Char65[0],Xspos,Yspos,width);
      break;
      
      case 'B':
      Char_Render_Type (&Char66[0],Xspos,Yspos,width);
      break;
      
      case 'C':
      Char_Render_Type (&Char67[0],Xspos,Yspos,width);
      break;
      
      case 'D':
      Char_Render_Type (&Char68[0],Xspos,Yspos,width);
      break;
      
      case 'E':
      Char_Render_Type (&Char69[0],Xspos,Yspos,width);
      break;
                                  
      case 'F':
      Char_Render_Type (&Char70[0],Xspos,Yspos,width);
      break;
      
      case 'G':
      Char_Render_Type (&Char71[0],Xspos,Yspos,width);
      break;
      
      case 'H':
      Char_Render_Type (&Char72[0],Xspos,Yspos,width);
      break;
      
      case 'I':
      Char_Render_Type (&Char73[0],Xspos,Yspos,width);
      break;
      
      case 'J':
      Char_Render_Type (&Char74[0],Xspos,Yspos,width);
      break;
      
      case 'K':
      Char_Render_Type (&Char75[0],Xspos,Yspos,width);
      break;
      
      case 'L':
      Char_Render_Type (&Char76[0],Xspos,Yspos,width);
      break;
      
      case 'M':
      Char_Render_Type (&Char77[0],Xspos,Yspos,width);
      break;
      
      case 'N':
      Char_Render_Type (&Char78[0],Xspos,Yspos,width);
      break;
      
      case 'O':
      Char_Render_Type (&Char79[0],Xspos,Yspos,width);
      break;
      
      case 'P':
      Char_Render_Type (&Char80[0],Xspos,Yspos,width);
      break;
      
      case 'Q':
      Char_Render_Type (&Char81[0],Xspos,Yspos,width);
      break;
      
      case 'R':
      Char_Render_Type (&Char82[0],Xspos,Yspos,width);
      break;
      
      case 'S':
      Char_Render_Type (&Char83[0],Xspos,Yspos,width);
      break;                        
      
      case 'T':
      Char_Render_Type (&Char84[0],Xspos,Yspos,width);
      break;
      
      case 'U':
      Char_Render_Type (&Char85[0],Xspos,Yspos,width);
      break;
      
      case 'V':
      Char_Render_Type (&Char86[0],Xspos,Yspos,width);
      break;
      
      case 'W':
      Char_Render_Type (&Char87[0],Xspos,Yspos,width);
      break;
      
      case 'X':
      Char_Render_Type (&Char88[0],Xspos,Yspos,width);
      break;
      
      case 'Y':
      Char_Render_Type (&Char89[0],Xspos,Yspos,width);
      break;
                                    
      case 'Z':
      Char_Render_Type (&Char90[0],Xspos,Yspos,width);
      break;
      
      case 'a':
      Char_Render_Type (&Char97[0],Xspos,Yspos,width);
      break;
      
      case 'b':
      Char_Render_Type (&Char98[0],Xspos,Yspos,width);
      break;
      
      case 'c':
      Char_Render_Type (&Char99[0],Xspos,Yspos,width);
      break;
      
      case 'd':
      Char_Render_Type (&Char100[0],Xspos,Yspos,width);
      break;
      
      case 'e':
      Char_Render_Type (&Char101[0],Xspos,Yspos,width);
      break;
      
      case 'f':
      Char_Render_Type (&Char102[0],Xspos,Yspos,width);
      break;
      
      case 'g':
      Char_Render_Type (&Char103[0],Xspos,Yspos,width);
      break;
      
      case 'h':
      Char_Render_Type (&Char104[0],Xspos,Yspos,width);
      break;
      
      case 'i':
      Char_Render_Type (&Char105[0],Xspos,Yspos,width);
      break;
      
      case 'j':
      Char_Render_Type (&Char106[0],Xspos,Yspos,width);
      break;
      
      case 'k':
      Char_Render_Type (&Char107[0],Xspos,Yspos,width);
      break;
      
      case 'l':
      Char_Render_Type (&Char108[0],Xspos,Yspos,width);
      break;
      
      case 'm':
      Char_Render_Type (&Char109[0],Xspos,Yspos,width);
      break;
      
      case 'n':
      Char_Render_Type (&Char110[0],Xspos,Yspos,width);
      break;
      
      case 'o':
      Char_Render_Type (&Char111[0],Xspos,Yspos,width);
      break;
      
      case 'p':
      Char_Render_Type (&Char112[0],Xspos,Yspos,width);
      break;
      
      case 'q':
      Char_Render_Type (&Char113[0],Xspos,Yspos,width);
      break;
      
      case 'r':
      Char_Render_Type (&Char114[0],Xspos,Yspos,width);
      break;
      
      case 's':
      Char_Render_Type (&Char115[0],Xspos,Yspos,width);
      break;
      
      case 't':
      Char_Render_Type (&Char116[0],Xspos,Yspos,width);
      break;
      
      case 'u':
      Char_Render_Type (&Char117[0],Xspos,Yspos,width);
      break;
      
      case 'v':
      Char_Render_Type (&Char118[0],Xspos,Yspos,width);
      break;
      
      case 'w':
      Char_Render_Type (&Char119[0],Xspos,Yspos,width);
      break;
      
      case 'x':
      Char_Render_Type (&Char120[0],Xspos,Yspos,width);
      break;
      
      case 'y':
      Char_Render_Type (&Char121[0],Xspos,Yspos,width);
      break;
      
      case 'z':
      Char_Render_Type (&Char122[0],Xspos,Yspos,width);
      break;
      
      case '0':
      Char_Render_Type (&Char48[0],Xspos,Yspos,width);
      break;
      
      case '1':
      Char_Render_Type (&Char49[0],Xspos,Yspos,width);
      break;
      
      case '2':
      Char_Render_Type (&Char50[0],Xspos,Yspos,width);
      break;
      
      case '3':
      Char_Render_Type (&Char51[0],Xspos,Yspos,width);
      break;
      
      case '4':
      Char_Render_Type (&Char52[0],Xspos,Yspos,width);
      break;
      
      case '5':
      Char_Render_Type (&Char53[0],Xspos,Yspos,width);
      break;
      
      case '6':
      Char_Render_Type (&Char54[0],Xspos,Yspos,width);
      break;
      
      case '7':
      Char_Render_Type (&Char55[0],Xspos,Yspos,width);
      break;
      
      case '8':
      Char_Render_Type (&Char56[0],Xspos,Yspos,width);
      break;
      
      case '9':
      Char_Render_Type (&Char57[0],Xspos,Yspos,width);
      break;
      
      case '%':
      Char_Render_Type (&Char37[0],Xspos,Yspos,width);          
      break;
      
      case '!':
      Char_Render_Type (&Char33[0],Xspos,Yspos,width);
      break;
      
      case '?':
      Char_Render_Type (&Char63[0],Xspos,Yspos,width);
      break;
      
      case '.':
      Char_Render_Type (&Char46[0],Xspos,Yspos,width);
      break;
      
      case '&':
      Char_Render_Type (&Char38[0],Xspos,Yspos,width);
      break;
      
      case ',':
      Char_Render_Type (&Char44[0],Xspos,Yspos,width);
      break;
      
      case ' ':
      Char_Render_Type (&Char32[0],Xspos,Yspos,width);
      break;
      
      case ':':
      Char_Render_Type (&Char58[0],Xspos,Yspos,width);
      break;
      
      case 0x13: //Carriage Return
      //Char_Render_Type (&Char58[0],Xspos,Yspos,width);
      break;
      
      //case 0x10: //Line Feed
      //Char_Render_Type (&Char58[0],Xspos,Yspos,width);
      //break;
      
      default:
      Char_Render_Type (&Char63[0],Xspos,Yspos,width);
      break;
    }                            
    string++;
    Yspos = Yspos+width+1;
    if(Yspos >= 160)
    {
     Yspos = 1;
     Xspos -= 11;
    }
  }
 }
 
 /********************************************************************************/
  void New_fntcolor (UINT8 RF, UINT8 GF, UINT8 BF, UINT8 RB, UINT8 GB, UINT8 BB)
 {
  fntcolor [0]= RF;
  fntcolor [1]= GF;
  fntcolor [2]= BF;
  bkgcolor [0]= RB;
  bkgcolor [1]= GB;
  bkgcolor [2]= BB;
  LookUpTableGen();
 }
 